# first line: 1
@mem.cache
def simulate_data(baseline, alpha, mu, sigma, T, dt, seed=0, kernel='RC'):
    L = int(1 / dt)
    discretization = torch.linspace(0, 1, L)
    u = mu - sigma
    if kernel == 'RC':
        RC = KernelRaisedCosineDiscret(dt)
        kernel_values = RC.eval(
            torch.Tensor(u), torch.Tensor(sigma), discretization
        )  # * dt
        kernel_values = kernel_values * alpha[:, :, None]
        k = kernel_values[0, 0].double().numpy()
    elif kernel == 'SG':
        kernel_values = torch.tensor(skewnorm.pdf(np.linspace(-3,3,100), 3))
        kernel_values = kernel_values * alpha[:, :, None]
        k = kernel_values.squeeze().numpy()
        
    #kernel_values = torch.tensor(beta.pdf(discretization.numpy(), 2, 3))

    t_values = discretization.double().numpy()
    

    tf = HawkesKernelTimeFunc(t_values=t_values, y_values=k)
    kernels = [[tf]]
    hawkes = SimuHawkes(
        baseline=baseline, kernels=kernels, end_time=T, verbose=False, seed=int(seed)
    )

    hawkes.simulate()
    events = hawkes.timestamps
    return events, hawkes
